@echo off
setlocal
cd /d "%~dp0"

echo ==========================================
echo   ComputeX Miner - Install (Python venv + deps)
echo ==========================================
echo.

where python >nul 2>nul
if errorlevel 1 (
  echo ERROR: Python is required but was not found on PATH.
  echo Install Python 3.10+ and ensure "Add Python to PATH" is checked:
  echo   https://www.python.org/downloads/
  echo.
  echo Opening Python download page...
  start "" "https://www.python.org/downloads/"
  pause
  exit /b 1
)

if not exist ".venv" (
  echo Creating virtual environment in .venv ...
  python -m venv .venv
  if errorlevel 1 (
    echo ERROR: Failed to create venv.
    pause
    exit /b 1
  )
)

echo Upgrading pip...
call ".venv\Scripts\python.exe" -m pip install --upgrade pip

echo Installing requirements...
call ".venv\Scripts\pip.exe" install -r requirements.txt
if errorlevel 1 (
  echo ERROR: pip install failed.
  pause
  exit /b 1
)

echo.
echo OK: Python environment ready.
echo.
exit /b 0
