@echo off
setlocal EnableExtensions EnableDelayedExpansion

REM ==========================================================
REM   ComputeX Miner - INSTALL_ALL (One Button)
REM
REM   1) Copies computex_miner to: C:\ComputeX\computex_miner
REM   2) Copies docs + README to:  C:\ComputeX\
REM   3) Installs Python venv + requirements
REM   4) Registers computex:// protocol (per-user)
REM
REM   IMPORTANT:
REM     - You must EXTRACT the ZIP first (do not run from inside ZIP viewer).
REM     - Install Python 3.10+ first: https://www.python.org/downloads/
REM ==========================================================

set "SRC=%~dp0"
set "ROOT=C:\ComputeX"
set "TARGET=%ROOT%\computex_miner"

echo ==========================================
echo   ComputeX Miner - INSTALL_ALL
echo ==========================================
echo Source : "%SRC%"
echo Target : "%TARGET%"
echo.

if not exist "%SRC%computex_miner\universal_miner.py" (
  echo ERROR: Missing computex_miner\universal_miner.py in source.
  echo You must run INSTALL_ALL.bat from the extracted package folder.
  pause
  exit /b 1
)

if not exist "%ROOT%" mkdir "%ROOT%" >nul 2>nul

echo [1/3] Copying miner files to %TARGET% ...
if not exist "%TARGET%" mkdir "%TARGET%" >nul 2>nul

where robocopy >nul 2>nul
if errorlevel 1 (
  xcopy "%SRC%computex_miner\*" "%TARGET%\" /E /I /Y >nul
) else (
  robocopy "%SRC%computex_miner" "%TARGET%" /E /R:2 /W:1 /NFL /NDL /NJH /NJS /NP >nul
)

echo [1b] Copying docs + README to %ROOT% ...
if not exist "%ROOT%\docs" mkdir "%ROOT%\docs" >nul 2>nul
where robocopy >nul 2>nul
if errorlevel 1 (
  xcopy "%SRC%docs\*" "%ROOT%\docs\" /E /I /Y >nul
) else (
  robocopy "%SRC%docs" "%ROOT%\docs" /E /R:2 /W:1 /NFL /NDL /NJH /NJS /NP >nul
)
if exist "%SRC%README_FIRST.txt" copy /Y "%SRC%README_FIRST.txt" "%ROOT%\README_FIRST.txt" >nul

if not exist "%TARGET%\universal_miner.py" (
  echo ERROR: universal_miner.py not found after copy.
  pause
  exit /b 1
)

echo [2/3] Installing Python requirements...
pushd "%TARGET%"
call "%TARGET%\install_windows.bat"
set "RC=%ERRORLEVEL%"
popd
if not "%RC%"=="0" (
  echo ERROR: install_windows.bat failed with code %RC%.
  pause
  exit /b %RC%
)

echo [3/3] Registering computex:// protocol (per-user)...
if exist "%TARGET%\register_computex_protocol.bat" (
  pushd "%TARGET%"
  call "%TARGET%\register_computex_protocol.bat"
  set "RC2=%ERRORLEVEL%"
  popd
) else (
  set "RC2=1"
)

if not "%RC2%"=="0" (
  echo WARNING: Per-user protocol registration failed.
  echo Trying .reg fallback (may require admin)...
  reg import "%TARGET%\register_computex_protocol.reg" >nul 2>nul
)

echo.
echo ==========================================
echo   DONE
echo ==========================================
echo Installed to:
echo   %TARGET%
echo.
echo Notes:
echo   - Clicking Run (computex://) will open a cmd.exe window. This is normal.
echo   - To mine: open ComputeX site -> Lease -> Run.
echo   - To claim: connect MetaMask and pay gas for the on-chain claim.
echo.
pause
endlocal
